//  Created by Allen Ingling on Wed Mar 31 2004.
//  Copyright (c) 2004 New York University. All rights reserved.


/* HipsViewer */


#import <Cocoa/Cocoa.h>
#import "HipsMovie.h"

#define MAXIMUM_BLIT_TIME_SAMPLES		65536

@class PlayMovie;

@interface HipsViewer : NSObject
{
	//outlets generated by Interface Builder
    IBOutlet id fileNameValueOutlet;
    IBOutlet id frameLabel;
    IBOutlet id frameNumberTextOutlet;
    IBOutlet id maxFrameLabel;
    IBOutlet id minFrameLabel;
    IBOutlet id glViewOutlet;
	IBOutlet id frameSliderOutlet;
	IBOutlet id viewHeaderButtonOutlet;
	IBOutlet id headerWindow;
	IBOutlet id headerTextView;
	IBOutlet id controlPanelWindowOutlet;
	//new for version 0.3
	IBOutlet id scaleLEnableOutlet;
	IBOutlet id scaleLClampToZeroRadioOutlet;
	IBOutlet id scaleLClampToMeanRadioOutlet;
	IBOutlet id scaleLFloatingZeroRadioOutlet;
	IBOutlet id fullscreenButtonOutlet;
	IBOutlet id screenNumberMenuOutlet;
	//new for version 0.4
	IBOutlet id backgroundColorBlackButtonOutlet;
	IBOutlet id backgroundColorMeanButtonOutlet;
	IBOutlet id backgroundColorMidgrayButtonOutlet;
	IBOutlet id backgroundColorWhiteButtonOutlet;
	IBOutlet id backgroundColorEdgeMeanButtonOutlet;
	IBOutlet id sampleBlitTimesSwitchOutlet;
	IBOutlet id viewBlitTimesButtonOutlet;
	IBOutlet id blitTimesWindowOutlet;
	IBOutlet id blitTimeTextViewOutlet;
	//new for version 0.5
	IBOutlet id synchToBlankSwitchOutlet;
	IBOutlet id progressBar;
	IBOutlet id progressWindow;
	IBOutlet id progressText;
	IBOutlet id displayModeMenuOutlet;
	IBOutlet id quitButtonOutlet;
	//new for version 0.6
	IBOutlet id previewViewOutlet;
	IBOutlet id previewWindowOutlet;
	IBOutlet id luminanceClampRadioMatrixOutlet;
	IBOutlet id backgroundColorRadioMatrixOutlet;
	IBOutlet id displayKeypressListButtonOutlet;
	//new for version 0.7
	IBOutlet id aboutWindowOutlet;
	//new for version 0.8
	IBOutlet id stepToEndButtonOutlet;
	IBOutlet id stepToStartButtonOutlet;
	IBOutlet id playOrPauseButtonOutlet;
	IBOutlet id stepBackwardButtonOutlet;
	IBOutlet id stepForwardButtonOutlet;
	IBOutlet id palindromeSwitchOutlet;
	IBOutlet id reverseSwitchOutlet;
	IBOutlet id loopSwitchOutlet;

	
	//additional variables
	double				keyscanMovieStartTime;
	double				keyscanMovieStopTime;
	BOOL				isMovieThreadPlaying;
	BOOL				recordKeysFlag;
	id					hipsMovie;
	BOOL				goMovieFlag;
	int					limitNumLoopPasses;
	BOOL				exitAfterPlay;
	BOOL				threadLock;
	int					currentFrameNumber;
	float				maximumFrameRate;
	float				minimumFrameRate;
	int					currentFrameRate;
	NSSound				*sliderBoundsAlertSound;
	int					frameIncrement;
	BOOL				palindromeBounceFlag;  //should we bounce (TRUE) or have we already (FALSE) ?	
	int					fullscreenNumber;
	CGDirectDisplayID   fullscreenDisplayID;
	CFArrayRef			displayModeList;
	NSOpenGLContext		*fullscreenNSGLContext;
	NSOpenGLContext		*previewNSGLContext;
	NSRect				fullscreenNSGLContextRect;
	NSRect				previewNSGLContextRect;
	//new
	double				*blitTimesArray;
	unsigned long		numTimeSamples;
	BOOL				captureDisplay;
	BOOL				use8BitMode;
	BOOL				enableInterfaceCoupling;
	BOOL				foobar;
	NSTimer				*autoRunTimer;
	BOOL				sampleBlitTimes;
	
	//variables for PlayMovie object
	NSConnection		*connectionToPlayMovie;
	PlayMovie			*player;
}
//  controls generated by interface builder
- (IBAction)frameSlider:(id)sender;
- (IBAction)openFile:(id)sender;
- (void)openFileFromStdInput;
- (IBAction)quitButton:(id)sender;
- (IBAction)viewHeader:(id)sender;
//  new for version 0.2
//  new for version 0.3
- (IBAction)scaleLEnable:(id)sender;
- (IBAction)scaleLClampToZeroRadio:(id)sender;
- (IBAction)scaleLClampToMeanRadio:(id)sender;
- (IBAction)scaleLFloatingZeroRadio:(id)sender;
- (IBAction)frameNumberText:(id)sender;
- (IBAction)fullscreenButton:(id)sender;
- (void)fullscreenCreateOrDestroy:(BOOL)create;
- (IBAction)screenNumberMenu:(id)sender;
// new for version 0.4
- (IBAction)backgroundColorBlackButton:(id)sender;
- (IBAction)backgroundColorWhiteButton:(id)sender;
- (IBAction)backgroundColorMidgrayButton:(id)sender;
- (IBAction)backgroundColorMeanButton:(id)sender;
- (IBAction)backgroundColorEdgeMeanButton:(id)sender;
- (IBAction)viewBlitTimesButton:(id)sender;
- (IBAction)synchToBlankSwitch:(id)sender;
// new for version 0.5
- (IBAction)displayModeMenu:(id)sender;
- (IBAction)displayKeypressListButton:(id)sender;
// new for version 0.7
- (IBAction)displayAboutWindow:(id)sender;
// new for version 0.8
- (IBAction)displayAboutWindow:(id)sender;
//new for version 0.8
- (IBAction)stepToEndButtonAction:(id)sender;
- (IBAction)stepToStartButtonAction:(id)sender;
- (IBAction)playOrPauseButtonAction:(id)sender;
- (IBAction)stepBackwardButtonAction:(id)sender;
- (IBAction)stepForwardButtonAction:(id)sender;
- (IBAction)reverseSwitchAction:(id)sender;
- (IBAction)loopSwitchAction:(id)sender;
- (IBAction)palindromeSwitchAction:(id)sender;
//new for version 0.9
- (IBAction)sampleBlitTimesSwitchAction:(id)sender;
	

//new for access by PlayMovie thread
- (void)setServer:(id)anObject;
- (BOOL)getPalindromeSwitchOutletState;
- (int)getFrameIncrement;
- (void)setFrameIncrement:(int)inc;
- (void)blitFrame;
- (BOOL)getLoopSwitchOutletState;
- (void)setFrameNumberControls;
- (int)getNumFrames;
- (int)getNumPlayLoops;
- (int)getFrameNumber;
- (void)setThreadLock:(BOOL)lockPlay;
- (void)setFrameNumber:(int)num;
- (BOOL)getRealtimeMode;
- (void)setNumPlayLoopPasses:(int)numPasses;
- (void)enableNonPlaytimeControls:(BOOL)enableOn;
- (BOOL)getGoMovieFlag;
- (void)activateRealtimeImmediate:(BOOL)priorityOn;
- (BOOL)checkForKeypress;
- (BOOL)getExitOnKeypress;
- (void)turnOffPlayButton;
- (int)getSampleBlitTimesSwitch;
- (void)setSampleBlitTimesFlag:(BOOL)value;


//additional methods
- (void)initMovieControls;
- (void)disableMovieControls;
- (void)enableExternalMovieControls;
- (void)enableIntrinsicMovieControls;
//new for version 0.2
- (void)disableScalingSwitches;
- (void)enableScalingSwitches;
//new for version 0.3
- (void)populateScreenMenu;
//- (void)enableDisplayChoiceControls;
//- (void)disableDisplayChoiceControls;
//new for version 0.4
- (void)enableBackgroundRadioButtons;
- (void)setBackgroundColor:(BackgroundColorModeType)backgroundColorMode blit:(BOOL)blitFlag;
- (BackgroundColorModeType)getFullscreeBackgroundModeFromButtons;
//new for version 0.5
- (ScaleModeType)getScaleModeFromButtons;
- (void)setButtonsFromScaleMode:(ScaleModeType)ScaleMode;
- (void)populateDisplayModeMenu;
- (void)printKeysAndExit;
//new for version 0.6
- (void)setupPreviewWindow;
//new for version 0.8
- (void)startAutoPlay;
//new for version 0.9
- (void)closeAllOpenStuff;



@end
